function [ lambda_a, lambda_b ] = getRegularisationResults( inputFolder )
%GETLAMBDASEARCHRESULTS Summary of this function goes here
%   Detailed explanation goes here


dimLabels = {'valence','arousal','power','expectancy'};

% find out the number of folds, and alpha, beta ranges

lambda_a = zeros(1,4);
lambda_b = zeros(1,4);


for dim=1:4
    
    folds = dir([inputFolder '/*' dimLabels{dim} '*.mat']);
    
    numFolds = numel(folds);
    if(numFolds > 0)
        load([inputFolder '/' folds(1).name]);
        fprintf('%s => \n', dimLabels{dim});
        resultsCorr = zeros(numFolds,length(lambdas_a), length(lambdas_b));
        resultsRMSE = zeros(numFolds,length(lambdas_a), length(lambdas_b));
        for fold=1:numFolds
            load([inputFolder '/' folds(fold).name]);

            resultsCorr(fold,:,:) = foldResultsCorr;    
            resultsRMSE(fold,:,:) = foldResultsRmse;    
        end


        %search for lambda which yields highest correlation
        aveCorrs = squeeze(mean(resultsCorr, 1));
        aveRmse = squeeze(mean(resultsRMSE, 1));
        
        [val,~] = max(max(aveCorrs));
        [a, b] = ind2sub(size(aveCorrs), find(aveCorrs == val));
        
        lambda_a(dim) = lambdaAValsCorr(a,b);
        lambda_b(dim) = lambdaBValsCorr(a,b);
        
        fprintf('Best lambdas are alpha - %g beta - %g (ave corr: %g)\n\n', ...
                lambda_a(dim), lambda_b(dim), val);    
    else
        fprintf('Warning no folds present for %s dimension\n', dimLabels{dim});
    end
end
end

